/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.hmcconfg;

import com.ibm.hwmca.base.hmcconfg.HmcConfigBean;
import com.ibm.hwmca.base.hmcconfg.HmcConfigErrorIds;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.base.vpdmgr.VpdData;
import com.ibm.hwmca.base.vpdmgr.VpdFileRecord;
import com.ibm.hwmca.base.vpdmgr.VpdManager;
import com.ibm.hwmca.base.vpdmgr.VpdManagerException;
import com.ibm.hwmca.base.vpdmgr.VpdRequestValue;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;

public class HmcConfigTasklet
extends PanelTasklet
implements HmcConfigErrorIds {
    private static final String TRACE_MASKT = "HCONCGTT";
    private static final String TRACE_MASKF = "HCONCGTF";
    private static final String TRACE_MASKD = "HCONCGTD";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(97, "HmcConfigTasklet");
    private static final String AUIML_FILE_NAME = "com.ibm.hwmca.base.hmcconfg.res.HmcConfigRes";
    private static final String PANEL_NAME = "HmcConfigPanel";
    private static final String HMCCONFIG_SUCCESS_MSG = "HMC0001";
    private static final String HMCCONFIG_FAILED_MSG = "HMC0002";

    public HmcConfigTasklet() {
        Trace.trace(TRACE_MASKT, "<> HmcConfigTasklet constructor");
    }

    public void service(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> HmcConfigTasklet.service()");
        if (taskletRequest.isInitialRequest()) {
            HmcConfigBean bean = new HmcConfigBean();
            try {
                this.showBusyDialog(new LocalizableText(BaseTextBundle.getBundleName(), "hmcconfig.busy.title"), new LocalizableText(BaseTextBundle.getBundleName(), "hmcconfig.busy.text"));
                VpdData vpddata = new VpdData(VpdRequestValue.CONFIG_REQUEST);
                VpdManager Vpd = VpdManager.getVpdManager();
                vpddata = Vpd.callVpdManager(vpddata);
                Trace.trace(TRACE_MASKF, "Setting SE machine type = " + vpddata.getVpdConfigurationExistData().getMachineModel().trim());
                Trace.trace(TRACE_MASKF, "Setting SE machine model = " + vpddata.getVpdConfigurationExistData().getMachineType().trim());
                Trace.trace(TRACE_MASKF, "Setting SE machine serial = " + vpddata.getVpdConfigurationExistData().getMachineSerial().trim());
                bean.setSystemModelEdit(vpddata.getVpdConfigurationExistData().getMachineModel().trim());
                bean.setSystemMachineTypeEdit(vpddata.getVpdConfigurationExistData().getMachineType().trim());
                bean.setSystemSerialEdit(vpddata.getVpdConfigurationExistData().getMachineSerial().trim());
                vpddata.setVpdCommand(VpdRequestValue.SEARCH_LOCATION);
                vpddata.getVpdInputData().setFruLocation("A00M_VPD_PCTM");
                vpddata = Vpd.callVpdManager(vpddata);
                VpdFileRecord record = (VpdFileRecord)vpddata.getSearchData().get(0);
                Trace.trace(TRACE_MASKF, "Setting HMC machine type = " + record.getFruFileData().getPartNumber().substring(0, 4));
                Trace.trace(TRACE_MASKF, "Setting HMC machine model = " + record.getFruFileData().getPartNumber().substring(4, 7));
                bean.setHmcMachineTypeOutput(record.getFruFileData().getPartNumber().substring(0, 4));
                bean.setHmcModelOutput(record.getFruFileData().getPartNumber().substring(4, 7));
                vpddata.getVpdInputData().setFruLocation("A00M_VPD_PCSN");
                vpddata = Vpd.callVpdManager(vpddata);
                record = (VpdFileRecord)vpddata.getSearchData().get(0);
                Trace.trace(TRACE_MASKF, "Setting HMC machine serial = " + record.getFruFileData().getPartNumber().trim());
                bean.setHmcSerialOutput(record.getFruFileData().getPartNumber().trim());
                this.destroyBusyDialog();
                taskletResponse.replace(AUIML_FILE_NAME, PANEL_NAME, bean);
            }
            catch (Exception exc) {
                Trace.trace(TRACE_MASKF, "Exception gathering VPD data = " + exc);
                TaskletException e = new TaskletException(exc);
                new FrameworkLog(logInfo, 516, e).log();
                MessageText[] messages = new BaseMessageText[]{new BaseMessageText(HMCCONFIG_FAILED_MSG)};
                this.showMessageBox(true, new LocalizableText(BaseTextBundle.getBundleName(), "hmcconfig.failed.title"), messages, HMCCONFIG_FAILED_MSG, MsgType.ERROR_MESSAGE, null);
                taskletResponse.terminate();
            }
        } else if (taskletRequest.isDisposed() || taskletRequest.isCanceled()) {
            taskletResponse.terminate();
        } else {
            HmcConfigBean bean = (HmcConfigBean)taskletRequest.getData("bean");
            String event = (String)taskletRequest.getData("command");
            Trace.trace(TRACE_MASKF, "event is: " + event);
            if (event.equals("OkButton")) {
                Trace.trace(TRACE_MASKF, "Updating HMC Congiuration");
                Trace.trace(TRACE_MASKF, "Setting SE machine type = " + bean.getSystemMachineTypeEdit());
                Trace.trace(TRACE_MASKF, "Setting SE machine model = " + bean.getSystemModelEdit());
                Trace.trace(TRACE_MASKF, "Setting SE machine serial = " + bean.getSystemSerialEdit());
                try {
                    VpdData vpddata = new VpdData(VpdRequestValue.CONFIG_ALTER);
                    VpdManager Vpd = VpdManager.getVpdManager();
                    vpddata.getVpdConfigurationNewData().setMachineType(bean.getSystemMachineTypeEdit());
                    vpddata.getVpdConfigurationNewData().setMachineModel(bean.getSystemModelEdit());
                    vpddata.getVpdConfigurationNewData().setMachineSerial(this.padSerial(bean.getSystemSerialEdit()));
                    vpddata = Vpd.callVpdManager(vpddata);
                }
                catch (VpdManagerException exc) {
                    Trace.trace(TRACE_MASKF, "Exception updating VPD data = " + exc);
                    TaskletException e = new TaskletException(exc);
                    new FrameworkLog(logInfo, 517, e).log();
                    MessageText[] messages = new BaseMessageText[]{new BaseMessageText(HMCCONFIG_FAILED_MSG)};
                    this.showMessageBox(true, new LocalizableText(BaseTextBundle.getBundleName(), "hmcconfig.failed.title"), messages, HMCCONFIG_FAILED_MSG, MsgType.ERROR_MESSAGE, null);
                    taskletResponse.terminate();
                }
                MessageText[] messages = new BaseMessageText[]{new BaseMessageText(HMCCONFIG_SUCCESS_MSG)};
                this.showMessageBox(true, new LocalizableText(BaseTextBundle.getBundleName(), "hmcconfig.success.title"), messages, HMCCONFIG_SUCCESS_MSG, MsgType.INFORMATION_MESSAGE, null);
                taskletResponse.terminate();
            } else {
                taskletResponse.terminate();
            }
        }
        Trace.trace(TRACE_MASKT, "<- HmcConfigTasklet.service()");
    }

    private String padSerial(String s) {
        Trace.trace(TRACE_MASKF, "<> HmcConfigTasklet.padSerial()");
        String dummyString = "000000000000";
        return dummyString.substring(0, dummyString.length() - s.length()).concat(s);
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> HmcConfigTasklet.logException()");
        Trace.trace(TRACE_MASKT, "processing exception: " + throwable);
        new FrameworkLog(logInfo, 513, throwable).log();
        Trace.trace(TRACE_MASKT, "<- HmcConfigTasklet.logException()");
    }
}

